<?php

    /*!
     * https://raccoonsquare.com
     * raccoonsquare@gmail.com
     *
     * Copyright 2012-2021 Demyanchuk Dmitry (raccoonsquare@gmail.com)
     */

    if (admin::isSession()) {

        header("Location: /admin/main");
        exit;
    }

    $page_id = "login";

    $user_username = '';

    $error = false;
    $error_message = '';

    if (!empty($_POST)) {

        $user_username = isset($_POST['user_username']) ? $_POST['user_username'] : '';
        $user_password = isset($_POST['user_password']) ? $_POST['user_password'] : '';
        $token = isset($_POST['authenticity_token']) ? $_POST['authenticity_token'] : '';

        $user_username = helper::clearText($user_username);
        $user_password = helper::clearText($user_password);

        $user_username = helper::escapeText($user_username);
        $user_password = helper::escapeText($user_password);

        if (helper::getAuthenticityToken() !== $token) {

            $error = true;
            $error_message = 'Error!';
        }

        if (!$error) {

            $access_data = array();

            $admin = new admin($dbo);
            $result = $admin->signin($user_username, $user_password);

            if (!$result['error']) {

                $clientId = 0; // Desktop version

                $admin->setId($result['accountId']);

                $access_data = $admin->createAuthorization($result['accountId'], $clientId, APP_TYPE_WEB);

                if (!$access_data['error']) {

                    admin::setSession($access_data['accountId'], $access_data['accessToken'], $result['username'], $result['fullname'], $result['access_level']);
                }

                header("Location: /admin/main");
                exit;

            } else {

                $error = true;
                $error_message = 'Incorrect login or password.';
            }
        }
    }

    helper::newAuthenticityToken();

    $page_id = "login";

    $css_files = array("mytheme.css");
    $page_title = "Admin| Log In";

    include_once("html/common/admin_header.inc.php");
?>

<body>

    <section id="wrapper">

        <div class="login-register light-gray-bg">

            <div class="login-box card">
                <div class="card-body">

                    <form class="form-horizontal form-material" id="loginform" action="/admin/login" method="post">

                        <input autocomplete="off" type="hidden" name="authenticity_token" value="<?php echo helper::getAuthenticityToken(); ?>">

                        <h3 class="box-title m-b-20">Log In</h3>

                        <p class="form-error-message" style="<?php if (!$error) echo "display: none"; ?>"><?php echo $error_message; ?></p>

                        <div class="form-group ">
                            <div class="col-xs-12">
                                <input class="form-control form-control-line" type="text" required="" placeholder="Username" name="user_username" value="<?php echo $user_username; ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-xs-12">
                                <input class="form-control" type="password" required="" placeholder="Password" name="user_password" value="">
                            </div>
                        </div>

                        <div class="form-group text-center m-t-20">
                            <div class="col-xs-12">
                                <button class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light" type="submit">Log In</button>
                            </div>
                        </div>

                    </form>


                </div>
            </div>
        </div>

    </section>

</body>
</html>
